<?php

header('Content-Type: application/json');

include "../includes/config.php";
include "../includes/mysql.php";
include "../includes/sessoes.php";
include "../includes/clicksign.php";
session_start();

if (!SessaoOk()) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa se autenticar',
    ]);
    exit();
}

$vistoriaId = isset($_POST['vistoriaId']) ? $_POST['vistoriaId'] : null;
if (!$vistoriaId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa selecionar uma vistoria',
    ]);
    exit();
}

$vistoria = dbFetchArray(dbQuery("
    SELECT *
    FROM vistorias
    WHERE id = $vistoriaId
"));
if (!$vistoria) {
    http_response_code(404);
    echo json_encode([
        'success' => false,
        'message' => 'Não existe vistoria para o ID fornecido',
    ]);
    exit();
}

$processoDeAssinaturaAtual = dbFetchArray(dbQuery("
    SELECT *
    FROM processos_de_assinatura
    WHERE vistoria_id = $vistoriaId AND document_status = 'running'
"));
if ($processoDeAssinaturaAtual) {
    http_response_code(422);
    echo json_encode([
        'success' => false,
        'message' => 'Já existe um processo de assinatura vigente. Cancele-o para criar um novo',
    ]);
    exit();
}

$signatarios = isset($_POST['signatarios']) ? $_POST['signatarios'] : [];
foreach ($signatarios as $i => $signatario) {
    $tipo = isset($signatario['tipo']) ? $signatario['tipo'] : null;
    if (!$tipo) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O tipo do signatário é obrigatório',
            'attribute' => "signatarios[$i].tipo"
        ]);
        exit();
    }
    $tipos = ['vistoriador', 'locador', 'locatario', 'outro'];
    if (!in_array($tipo, $tipos)) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O tipo do signatário deve ser um dentre: ' . implode(', ', $tipos),
            'attribute' => "signatarios[$i].tipo",
            'value' => $tipo,
        ]);
        exit();
    }
    $nome = isset($signatario['nome']) ? $signatario['nome'] : null;
    if (!$nome) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O nome do signatário é obrigatório',
            'attribute' => "signatarios[$i].nome"
        ]);
        exit();
    }
    if (count(explode(' ', trim($nome))) < 2) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O nome do signatário deve conter no mínimo duas partes',
            'attribute' => "signatarios[$i].nome",
            'value' => $nome,
        ]);
        exit();
    }
    $email = isset($signatario['email']) ? $signatario['email'] : null;
    if (!$email) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O email do signatário é obrigatório',
            'attribute' => "signatarios[$i].email"
        ]);
        exit();
    }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'O formato do email do signatário é inválido',
            'attribute' => "signatarios[$i].email",
            'value' => $email,
        ]);
        exit();
    }
}

global $urlbase_server;
$laudo = file_get_contents("$urlbase_server/gerar-laudo.php?vistoria=$vistoriaId&usuario={$_POST['usuario']}&senha={$_POST['senha']}");
if (!$laudo) {
    http_response_code(422);
    echo json_encode([
        'success' => false,
        'message' => 'Não foi possível gerar o documento de laudo para assinatura. Tente novamente em alguns instantes',
    ]);
    exit();
}
$content = base64_encode(
    $laudo
);

try {
    $clicksign = new Clicksign();
    $envelope = $clicksign->createEnvelope("Processo de Assinatura da Vistoria #$vistoriaId");
    if (!$envelope) {
        // Envelope não criado
        throw new Exception("Código de erro: INT_CS_PDA_C01");
    }
    $document = $clicksign->addDocumentToEnvelope($envelope['data']['id'], 'vistoria.pdf', "data:application/pdf;base64,$content");
    if (!$document) {
        // Documento não criado corretamente, é necessário retentar o envio, e então criar o processo de assinatura com os signatários
        throw new Exception("Código de erro: INT_CS_PDA_C02");
    }
    $envelopeId = $envelope['data']['id'];
    $documentId = $document['data']['id'];
    $documentStatus = $document['data']['attributes']['status'];

    dbQuery("
        INSERT INTO processos_de_assinatura 
            (vistoria_id, envelope_id, document_id, document_status)
        VALUES 
            ($vistoriaId, '$envelopeId', '$documentId', '$documentStatus')
    ");

    $processoDeAssinaturaId = dbInsertId();

    foreach ($signatarios as $signatario) {
        $tipo = $signatario['tipo'];
        $nome = $signatario['nome'];
        $email = $signatario['email'];

        dbQuery("
            INSERT INTO signatarios_dos_processos
                (processo_de_assinatura_id, tipo, nome, email)
            VALUES
                ($processoDeAssinaturaId, '$tipo', '$nome', '$email')
        ");
    }

    http_response_code(201);
    echo json_encode([
        'success' => true,
        'message' => 'Processo de Assinatura criado com sucesso',
        'processoDeAssinatura' => [
            'id' => $processoDeAssinaturaId,
            'status' => $documentStatus,
        ],
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
    ]);
}
